{*=====================================================================
  Project:   PictureHEXView.bdsproj

  File:      PictureHEXView_.pas

  Summary:
       PictureHEXView is a simple picture and color-in-hexa viewer.
       On other hand it could demonstrate the using OpenFileDialog
       for loading image files and Type-overcasting for get color
       codes for a pixel.

-----------------------------------------------------------------------
  This file is submitted by:

  endresy@axelero.hu
  Endre I. Simay,
  Hungary


THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
=====================================================================*}

unit PictureHEXView_;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.IO;

type
  TWinForm = class(System.Windows.Forms.Form)
{$REGION 'Designer Managed Code'}
    strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    button1: System.Windows.Forms.Button;
    panel1: System.Windows.Forms.Panel;
    pictureBox1: System.Windows.Forms.PictureBox;
    label1: System.Windows.Forms.Label;
    label2: System.Windows.Forms.Label;
    label3: System.Windows.Forms.Label;
    openFileDialog1: System.Windows.Forms.OpenFileDialog;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure pictureBox1_MouseMove(sender: System.Object; e: System.Windows.Forms.MouseEventArgs);
    procedure button1_Click(sender: System.Object; e: System.EventArgs);
{$ENDREGION}
    strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  private
    function open_and_view(): boolean;
  end;

implementation

uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>

procedure TWinForm.InitializeComponent;
begin
  Self.button1 := System.Windows.Forms.Button.Create;
  Self.panel1 := System.Windows.Forms.Panel.Create;
  Self.pictureBox1 := System.Windows.Forms.PictureBox.Create;
  Self.label1 := System.Windows.Forms.Label.Create;
  Self.label2 := System.Windows.Forms.Label.Create;
  Self.label3 := System.Windows.Forms.Label.Create;
  Self.openFileDialog1 := System.Windows.Forms.OpenFileDialog.Create;
  Self.panel1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // button1
  // 
  Self.button1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
      or System.Windows.Forms.AnchorStyles.Left)));
  Self.button1.Location := System.Drawing.Point.Create(8, 248);
  Self.button1.Name := 'button1';
  Self.button1.Size := System.Drawing.Size.Create(88, 23);
  Self.button1.TabIndex := 0;
  Self.button1.Text := 'Load Image ...';
  Include(Self.button1.Click, Self.button1_Click);
  // 
  // panel1
  // 
  Self.panel1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.panel1.AutoScroll := True;
  Self.panel1.Controls.Add(Self.pictureBox1);
  Self.panel1.Location := System.Drawing.Point.Create(8, 8);
  Self.panel1.Name := 'panel1';
  Self.panel1.Size := System.Drawing.Size.Create(360, 232);
  Self.panel1.TabIndex := 1;
  // 
  // pictureBox1
  // 
  Self.pictureBox1.Location := System.Drawing.Point.Create(0, 0);
  Self.pictureBox1.Name := 'pictureBox1';
  Self.pictureBox1.SizeMode := System.Windows.Forms.PictureBoxSizeMode.AutoSize;
  Self.pictureBox1.TabIndex := 2;
  Self.pictureBox1.TabStop := False;
  Include(Self.pictureBox1.MouseMove, Self.pictureBox1_MouseMove);
  // 
  // label1
  // 
  Self.label1.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
      or System.Windows.Forms.AnchorStyles.Left)));
  Self.label1.ForeColor := System.Drawing.Color.FromArgb((Byte(192)), (Byte(0)), (Byte(0)));
  Self.label1.Location := System.Drawing.Point.Create(112, 256);
  Self.label1.Name := 'label1';
  Self.label1.Size := System.Drawing.Size.Create(72, 16);
  Self.label1.TabIndex := 3;
  Self.label1.Text := 'Red  :';
  // 
  // label2
  // 
  Self.label2.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
      or System.Windows.Forms.AnchorStyles.Left)));
  Self.label2.ForeColor := System.Drawing.Color.FromArgb((Byte(0)), (Byte(192)), (Byte(0)));
  Self.label2.Location := System.Drawing.Point.Create(200, 256);
  Self.label2.Name := 'label2';
  Self.label2.Size := System.Drawing.Size.Create(72, 16);
  Self.label2.TabIndex := 4;
  Self.label2.Text := 'Green :';
  // 
  // label3
  // 
  Self.label3.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
      or System.Windows.Forms.AnchorStyles.Left)));
  Self.label3.ForeColor := System.Drawing.Color.FromArgb((Byte(0)), (Byte(0)), (Byte(192)));
  Self.label3.Location := System.Drawing.Point.Create(288, 256);
  Self.label3.Name := 'label3';
  Self.label3.Size := System.Drawing.Size.Create(72, 16);
  Self.label3.TabIndex := 5;
  Self.label3.Text := 'Blue :';
  // 
  // openFileDialog1
  // 
  Self.openFileDialog1.Filter := 'All known (*.bmp;*.gif;*.ico;*.jpg;*.png)|*.bmp;*.gif;*.ico;*.jpg;*.png';
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(377, 293);
  Self.Controls.Add(Self.label3);
  Self.Controls.Add(Self.label2);
  Self.Controls.Add(Self.label1);
  Self.Controls.Add(Self.panel1);
  Self.Controls.Add(Self.button1);
  Self.MinimumSize := System.Drawing.Size.Create(385, 320);
  Self.Name := 'TWinForm';
  Self.Text := 'PictureHexView for Delphi.NET by E. I. Simay';
  Self.panel1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.button1_Click(sender: System.object; e: System.EventArgs);
begin
  if (openFileDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK) then
  begin
    if (not open_and_view()) then
    begin
      // a simple error-recording
      MessageBox.Show('Problem with picture path or format.' + 'Sorry', 'Pictureview Error',
        MessageBoxButtons.OK);
    end;
  end;
end;

procedure TWinForm.pictureBox1_MouseMove(sender: System.object; e: System.Windows.Forms.MouseEventArgs);
var
  color: System.Drawing.Color;
  stemp: string;
begin
  if (pictureBox1.Image <> nil) then
  begin
  // The Image-type has not a GetPixel function. So we use the Bitmap's one
    color := (System.Drawing.Bitmap(pictureBox1.Image)).GetPixel(e.X, e.Y);
    // A very stone-axe method to padding the byte to hexa with 2 chars
    stemp := color.R.ToString('X');
    if (stemp.Length = 1) then
    begin
      stemp := '0' + stemp;
    end;
    label1.Text := 'Red  : 0x' + stemp;

    stemp := color.G.ToString('X');
    if (stemp.Length = 1) then
    begin
      stemp := '0' + stemp;
    end;
    label2.Text := 'Green: 0x' + stemp;

    stemp := color.B.ToString('X');
    if (stemp.Length = 1) then
    begin
      stemp := '0' + stemp;
    end;
    label3.Text := 'Blue : 0x' + stemp;
  end;
end;

function TWinForm.open_and_view(): boolean;
var
  fname: string;
begin
  fname := openFileDialog1.FileName;
  result := true;
  if (fname <> '') then
  begin
    try
      try
        if (pictureBox1.Image <> nil) then
        begin
          pictureBox1.Image.Dispose();
        end;
        pictureBox1.Image := System.Drawing.Image.FromFile(fname);
      except
        on exception do result := false;
      end;
    except
      on exception do result := false;
    end;
  end
  else
  begin
    result := false;
  end;
end;

end.
